EnableExplicit

Structure rgb
  r.a
  g.a
  b.a
EndStructure

Structure rgb_color
  StructureUnion
    rgb.rgb
    Color.l
  EndStructureUnion
EndStructure

Structure Pos_Pixel
  x.u
  y.u
EndStructure

Structure PosPixel
  StructureUnion
    Pos.Pos_Pixel
    xy.l
  EndStructureUnion
EndStructure

Structure Arr_Pos_Pixel
  Arr.PosPixel[0]
EndStructure

Structure List_Pos_Pixel
  List Pos.PosPixel()
EndStructure

#FP_SM_Def = 0  
#FP_SM_Clip = 1

Global g_List_Pos_Pixel.List_Pos_Pixel
Global g_SearchMode.l = #FP_SM_Clip

#Image = 0

Macro WinSize()
  If hWnd And x=0 And y=0 And Width=0 And Height=0
    Protected WinSize.RECT
    If GetWindowRect_(hWnd, @WinSize)
      x=0
      y=0
      Width=WinSize\right-WinSize\left
      Height=WinSize\bottom-WinSize\top
    Else
      ProcedureReturn Result
    EndIf
  EndIf
EndMacro

Procedure MakeScreen(Image, x, y, Width, Height, hWnd) 
  Protected hImage=0, hDC, SrcDC
  hImage = CreateImage(Image, Width, Height, 24) 
  If hImage
    If hWnd
     SrcDC = GetWindowDC_(hWnd)
    Else
     SrcDC = GetDC_(0)
    EndIf
    If SrcDC
      hDC    = StartDrawing(ImageOutput(Image))
      If hDC 
        BitBlt_(hDC, 0, 0, Width, Height, SrcDC, x, y, #SRCCOPY) 
        StopDrawing()
      Else
        Goto ms_m1
      EndIf
      ReleaseDC_(hWnd, SrcDC)
    Else
      Goto ms_m1
    EndIf
  Else
    ms_m1:
    FreeImage(Image)
    hImage=0
  EndIf
  ProcedureReturn hImage
EndProcedure

Macro SetData()
  Pos\Pos\x = x
  Pos\Pos\y = y
  Result = Pos\xy
  
  If *PixelList = 0
    Break 2
  Else
    If AddElement(*PixelList\Pos())
      *PixelList\Pos()\Pos\x = x
      *PixelList\Pos()\Pos\y = y
    EndIf
  EndIf
EndMacro

Procedure.l Search_Pixel(Image,P_x, P_y, P_Width, P_Height, P_Color.l, Shade.a, Steps, *PixelList.List_Pos_Pixel = 0)
  Protected Result.l = -1, StepPos=0
  Protected x, y, h, w, Width, Height, Color.l
  Protected MinColor.rgb, MaxColor.rgb, Pos.PosPixel
  Protected *ColorByte.rgb, *Color.rgb_color=@Color
  
  If P_x>=0 And P_y>=0 And P_Width>=0 And P_Height>=0 And Steps>0
    
    P_Width + P_x : P_Height+P_y
    
    If P_Width>=P_x And P_Height>=P_y
      
      x=P_x : y=P_y
      w=P_Width : h=P_Height
      
      If Shade<>0
        If Red(P_Color)-Shade>0
          MinColor\r = Red(P_Color)-Shade
        EndIf
        
        If Green(P_Color)-Shade>0
          MinColor\g = Green(P_Color)-Shade
        EndIf
        
        If Blue(P_Color)-Shade>0
          MinColor\b = Blue(P_Color)-Shade
        EndIf
        
        If Red(P_Color)+Shade<255
          MaxColor\r = Red(P_Color)+Shade
        Else
          MaxColor\r = 255
        EndIf
        
        If Green(P_Color)+Shade<255
          MaxColor\g = Green(P_Color)+Shade
        Else
          MaxColor\g = 255
        EndIf
        
        If Blue(P_Color)+Shade<255
          MaxColor\b = Blue(P_Color)+Shade
        Else
          MaxColor\b = 255
        EndIf
      EndIf
      
      If StartDrawing(ImageOutput(Image))
        
        Width = OutputWidth()
        Height = OutputHeight()
        
        If w>=Width : w=Width-1 : EndIf
        If h>=Height : h=Height-1 : EndIf
        
        If  w>=x And h>=y And w>0 And h>0
          
          Result=-2
          
          While y<h
            While x<w
              
              Color = Point(x, y)
              
              If Shade=0
                If P_Color = Color
                  SetData()
                EndIf
              Else
                
                If *Color\rgb\r>=MinColor\r And *Color\rgb\r<=MaxColor\r And *Color\rgb\g>=MinColor\g And *Color\rgb\g<=MaxColor\g And *Color\rgb\b>=MinColor\b And *Color\rgb\b<=MaxColor\b
                  
                  SetData()
                EndIf
                
              EndIf
              
              x+Steps
            Wend 
            y+(x/w)
            x=x%w
            
            If g_SearchMode & #FP_SM_Clip
              x + P_x
            EndIf
            
          Wend
          
        EndIf
        
        StopDrawing()
      EndIf
      
    EndIf
  EndIf
  
  ProcedureReturn Result
EndProcedure

Procedure.l GetPixel(Image, x, y)
  Protected Result = -1
  Protected Width, Height
  
  If x>=0 And y>=0
    If StartDrawing(ImageOutput(Image))
      Width = OutputWidth()
      Height = OutputHeight()
      
      If x<Width And y<Height
        Result = Point(x, y)
      EndIf
      
      StopDrawing()
    EndIf
  EndIf
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL FindPixel(x, y, Width, Height, Color.l, Shade.a, Steps, hWnd)
  Protected Result.l = -1, *Pos.Pos_Pixel
  
  WinSize()
  
  If MakeScreen(#Image, x, y, Width, Height, hWnd)
    Result = Search_Pixel(#Image, 0, 0, Width, Height, Color, Shade, Steps)
    If Result<>-1 And Result<>-2
      *Pos=@Result
      *Pos\x+x
      *Pos\y+y
    EndIf
  EndIf
  ProcedureReturn Result
EndProcedure

ProcedureDLL FindPixel_Buff(x, y, Width, Height, Color.l, Shade.a, Steps)
  Protected Result.l = -1
  If IsImage(#Image)
    Result = Search_Pixel(#Image, x, y, Width, Height, Color, Shade, Steps)
  EndIf
  ProcedureReturn Result
EndProcedure

ProcedureDLL FindPixel_Buff_ToArr(x, y, Width, Height, Color.l, Shade.a, Steps)
  Protected Result.l = -1
  If IsImage(#Image)
    ClearList(g_List_Pos_Pixel\Pos())
    Result = Search_Pixel(#Image, x, y, Width, Height, Color, Shade, Steps, @g_List_Pos_Pixel)
    If Result>=0
      Result = ListSize(g_List_Pos_Pixel\Pos())
    EndIf
  EndIf
  ProcedureReturn Result
EndProcedure

ProcedureDLL GetPixelArr(*Buff.Arr_Pos_Pixel, Count)
  Protected Result = -1, i=0
  
  If *Buff And Count>0
    Result = ListSize(g_List_Pos_Pixel\Pos())
    If Result>0
      
      If Count>Result
        Count=Result
      EndIf
      
      ForEach g_List_Pos_Pixel\Pos()
        
        *Buff\Arr[i]\xy = g_List_Pos_Pixel\Pos()\xy
        
        i+1
        
        If i>=Count
          Break
        EndIf
        
      Next
      
      Result = i
      
    EndIf
  EndIf
  
  ClearList(g_List_Pos_Pixel\Pos())
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL GetPixel_Buff(x, y)
  Protected Result.l = -1
  If IsImage(#Image)
    Result = GetPixel(#Image, x, y)
  EndIf
  ProcedureReturn Result
EndProcedure

ProcedureDLL ScreenToBuff(x, y, Width, Height, hWnd)
  Protected Result = 0
  
  WinSize()
  Result =  MakeScreen(#Image, x, y, Width, Height, hWnd)
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL ImageLoadMem(*Mem, Size)
  Protected Result = #False
  
  If *Mem And Size>0
    Result = CatchImage(#Image, *Mem, Size)
  EndIf
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL ImageLoadHandle(hBmp)
  Protected Result = #False
  Protected Bmp.BITMAP
  
  If hBmp
    If GetObjectType_(hBmp) = #OBJ_BITMAP
      If GetObject_(hBmp, SizeOf(Bmp), @Bmp)>0
        If Bmp\bmWidth>0 And Bmp\bmHeight>0
          
          If CreateImage(#Image, Bmp\bmWidth, Bmp\bmHeight, 24)
            If StartDrawing(ImageOutput(#Image))
              DrawImage(hBmp, 0, 0, Bmp\bmWidth, Bmp\bmHeight)
              StopDrawing()
              Result = #True
            EndIf
          EndIf
          
        EndIf
      EndIf
    EndIf
  EndIf
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL ImageLoad(FileName.s)
  Protected Result = #False
  
  If FileName
    Result = LoadImage(#Image, FileName)
  EndIf
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL ImageSave(FileName.s)
  Protected Result = #False
  
  If IsImage(#Image) And FileName
    Result = SaveImage(#Image, FileName, #PB_ImagePlugin_BMP)
  EndIf
  
  ProcedureReturn Result
EndProcedure

ProcedureDLL ImageGetHandle()
  Protected Result = 0
 
  If IsImage(#Image)
    Result = ImageID(#Image)
  EndIf
 
  ProcedureReturn Result
EndProcedure

ProcedureDLL GetSearchMode()
  ProcedureReturn g_SearchMode
EndProcedure

ProcedureDLL SetSearchMode(Mode)
  g_SearchMode = Mode
EndProcedure

ProcedureDLL DetachProcess(Instance)
  If IsImage(#Image)
    FreeImage(#Image)
  EndIf
EndProcedure


; IDE Options = PureBasic 5.00 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 36
; FirstLine = 27
; Folding = ----
; Executable = FindPixel.dll
; EnableBuildCount = 36
; IncludeVersionInfo
; VersionField0 = 1.4.0.0
; VersionField1 = 1.4.0.0
; VersionField2 = Prog
; VersionField3 = FindPixel
; VersionField4 = 1.4
; VersionField5 = 1.4.0.%BUILDCOUNT
; VersionField6 =   
; VersionField7 = %SOURCE
; VersionField8 = %EXECUTABLE
; VersionField9 = Prog
; VersionField15 = VOS_NT_WINDOWS32
; VersionField16 = VFT_DLL
; VersionField17 = 0419 Russian
; VersionField18 = Build
; VersionField21 = %BUILDCOUNT